﻿#include  "StdAfx.h"

#include  <szArchiveUpdater.hpp>
#include  <szCodecManager.hpp>
#include  <szRuntimeException.hpp>
#include  <7zip/UI/Common/Update.h>
#include  "szArchiveFileUpdaterImpl.hpp"

inline void AddProperty(CUpdateOptions *uo, const szchar *propName, const szchar *propValue)
{
  CProperty prop;
  prop.Name = propName;
  prop.Value = propValue;
  uo->MethodMode.Properties.Add(prop);
}

SZ_NS_BEG(szpp)

ArchiveUpdaterOptions::ArchiveUpdaterOptions()
: ArchiveType(), Method(), Solid(), Password(), EncryptionMethod(), Sfx(false), EncryptNames(false)
{
}

//ArchiveUpdater::ArchiveUpdater()
//{
//}
//
//ArchiveUpdater::~ArchiveUpdater()
//{
//}

// openCallback, updCallback, archiveName
void ArchiveUpdater::Update(const std::vector<szstring> &paths,
                            const szstring &archivePath,
                            const ArchiveUpdaterOptions *options,
                            ArchiveOpenClientCallback *openCallback,
                            ArchiveFileUpdateClientCallback *updCallback,
                            GetPasswordClientCallback *pwdCallback)
{
  // ArchiveFileUpdaterImpl 自身は擬似 COM クラスではないので、CMyComPtr ではなく auto_ptr でよい
  std::auto_ptr<ArchiveFileUpdaterImpl> impl(new ArchiveFileUpdaterImpl(openCallback, updCallback, pwdCallback));

  CUpdateOptions uo;

  // コマンドの設定
  //NCommandType::EEnum commandType = EEnum::kAdd;
  //NUpdateArchive::CActionSet defaultActionSet;
  //switch(commandType)
  //{
  //  case NCommandType::kAdd:
  //    defaultActionSet = NUpdateArchive::kAddActionSet;
  //    break;
  //  case NCommandType::kDelete:
  //    defaultActionSet = NUpdateArchive::kDeleteActionSet;
  //    break;
  //  default:
  //    defaultActionSet = NUpdateArchive::kUpdateActionSet;
  //}
  NUpdateArchive::CActionSet defaultActionSet = NUpdateArchive::kAddActionSet;
  
  uo.UpdateArchiveItself = true;
  
  uo.Commands.Clear();
  CUpdateArchiveCommand updateMainCommand;
  updateMainCommand.ActionSet = defaultActionSet;
  uo.Commands.Add(updateMainCommand);

  //if (parser[NKey::kUpdate].ThereIs)
  //  ParseUpdateCommandString(options, parser[NKey::kUpdate].PostStrings,
  //      defaultActionSet);
  //if (parser[NKey::kWorkingDir].ThereIs)
  //{
  //  const UString &postString = parser[NKey::kWorkingDir].PostStrings[0];
  //  if (postString.IsEmpty())
  //    NDirectory::MyGetTempPath(options.WorkingDir);
  //  else
  //    options.WorkingDir = postString;
  //}

  if (options != 0)
  {
    if (options->Sfx)
    {
      uo.SfxMode = true;
      uo.SfxModule = SZL("7z.sfx");
    }

#ifndef _NO_CRYPTO
    if (!options->Password.empty())
    {
      // パスワードが渡されていればそれでコールバックのパスワードを初期化
      impl->SetInitialPassword(options->Password);
    }
#endif
  }

  AddProperty(&uo, SZL("x"), options->Level.c_str());

  if (options->ArchiveType == SZL("7z"))
  {
    // 例えば Zip 形式の時にソリッドオンとか指定するとエラーになるので、7-Zip のときだけ必要な処理は if で囲っておく

    // ソリッド
    AddProperty(&uo, SZL("S"), options->Solid.c_str());

    // ファイル名も圧縮
    if (options->EncryptNames && !options->Password.empty())
      AddProperty(&uo, SZL("HE"), SZL("+"));

    // メソッド
    if (!options->Method.empty())
      AddProperty(&uo, SZL("0"), options->Method.c_str());
  }
  else
  {
    // メソッド
    if (!options->Method.empty())
      AddProperty(&uo, SZL("m"), options->Method.c_str());
  }


  // マルチスレッド
  AddProperty(&uo, SZL("mt"), SZL("+"));

  CUpdateErrorInfo errorInfo;
  CIntVector formatIndices;

  if (!CodecManager::GetCodecs()->FindFormatForArchiveType(options->ArchiveType.c_str(), formatIndices))
    BOOST_THROW_EXCEPTION(RuntimeException(SZT("Cannot create handler")));

  if (!uo.Init(CodecManager::GetCodecs(), formatIndices, archivePath.c_str()))
    BOOST_THROW_EXCEPTION(RuntimeException(SZT("Cannot create handler")));

  // ワイルドカードはすべて圧縮するように設定しておく
  // Exclude マスクなんかを指定できるように改良するということも考えられる。
  NWildcard::CCensor censor;
  for (size_t i = 0; i < paths.size(); ++i)
    censor.AddItem(true, paths[i].c_str(), false);

  HRESULT hr = UpdateArchive(CodecManager::GetCodecs(), censor, uo, errorInfo, impl.get(), impl.get());
  if (!SUCCEEDED(hr))
    BOOST_THROW_EXCEPTION(RuntimeException(SZT("Cannot update the archive")) << hresult_info(hr));
}

SZ_NS_END(szpp)
